<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class WeekelyShiftSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $weekNames = ['الأول', 'الثاني', 'الثالث', 'الرابع','الخامس','السادس','السابع','الثامن','التاسع','العاشر','الحادى عشر','الثاني عشر','الثالث عشر','الرايع عشر','الخامس عشر'];

        \App\Models\ManagerDashboard\Tables\ShiftSchedule\ShiftSchedule::factory(20)->create()->each(function ($shift) use ($weekNames) {
            $teachers = \App\Models\ManagerDashboard\Tables\Teacher::all()->random(rand(1, 3))->pluck('id');
            // Randomly pick 1 to 3 teachers
            foreach ($teachers as $teacherId) {
                DB::table('shift_teachers')->insert([
                    'shift_id' => $shift->id,
                    'teacher_id' => $teacherId,
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);
            }
        });
    }
}
