<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use App\Models\AdminDashboard\Procedures\AbsenceProcedure\ProcedureName;

class ProcedureNameSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $numbersInArabic = [
            1 => 'الاول',
            2 => 'الثاني',
            3 => 'الثالث',
            4 => 'الرابع',
            5 => 'الخامس',
            6 => 'السادس',
            7 => 'السابع',
            8 => 'الثامن',
            9 => 'التاسع',
            10 => 'العاشر'
        ];

        foreach ($numbersInArabic as $number => $word) {
            ProcedureName::create([
                'name' => "الإجراء $word"
            ]);
        }
    }
}
