<?php

namespace Database\Seeders;

use App\Models\AdminDashboard\Category\Category;
use App\Models\NamazegCategory;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class NamazegCategoriesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $categories = [
            [
                'name' => 'الأدلة واللوائح',
                'subCategoriesNames' => [
                    'الأدلة الاجرائية',
                    'الادلة التعليمية نظام مسارات',
                    'الأدلة المنظمة للعمل',
                    'الأدلة التنظيمية',
                    'أدلة اخرى',
                    'دليل التقويم والاختبارات',
                    'اللوائح والادلة التعليمية'
                ]
            ],
            [
                'name' => 'مديرة المدرسة',
                'subCategoriesNames' => [
                    'نماذج المدرسة',
                    'قسم الجودة',
                    'قضايا شاغلى التعليم',
                ]
            ],
            [
                'name' => 'الشئون التعليمية',
                'subCategoriesNames' => [
                    'عام',
                    'سجلات المتابعة',
                ]
            ],
            [
                'name' => 'شئون الطالبات',
                'subCategoriesNames' => [
                    'افادات وتعهدات',
                    'حصص الاتقان',
                    'عام',
                ]
            ],
            [
                'name' => 'الشئون المدرسية',
                'subCategoriesNames' => [
                    'منسوبى المدرسة',
                    'سجلات',
                    'عام',
                ]
            ],
            [
                'name' => 'أغلفة السجلات',
                'subCategoriesNames' => [
                    'كليشات'
                ]
            ]
        ];
        foreach ($categories as $parentCategory) {
            $new_category = NamazegCategory::create([
                'name' => $parentCategory['name']
            ]);
            foreach ($parentCategory['subCategoriesNames'] as $subCategory) {
                NamazegCategory::create([
                    'name' => $subCategory,
                    'parent_id' => $new_category->id
                ]);
            }
        }
    }
}
