<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTableExamsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('table_exams', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('school_id')->nullable();  
            $table->unsignedBigInteger('semester_id')->nullable(); 
            $table->enum('exam_type', ['final', 'periodic'])->default('periodic')->nullable(); 
            $table->enum('exam_category', ['verbal', 'practical', 'written'])->default('written')->nullable(); 
            $table->enum('table_type', ['different', 'standard'])->default('standard')->nullable(); 
            $table->string('start_date', 50)->nullable(); 
            $table->timestamps();
            $table->softDeletes();
            $table->foreign('school_id')->references('id')->on('schools')->onDelete('cascade');
            $table->foreign('semester_id')->references('id')->on('semesters')->onDelete('cascade');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('table_exams');
    }
}
