<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('namazeg_transform_quran_students', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('namazeg_version_id');
            $table->unsignedBigInteger('school_id');

            $table->string('student_name');
            $table->string('birth_date');
            $table->string('last_certificate');
            $table->string('certificate_source');
            $table->string('certificate_date');
            $table->string('trans_form');
            $table->string('trans_to');
            $table->enum('study_type',['eveninig','night','affilation']);

            $table->foreign('namazeg_version_id')->references('id')->on('namazeg_versions')->onDelete('cascade');
            $table->foreign('school_id')->references('id')->on('schools')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('namazeg_transform_quran_students');
    }
};
