<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('namazeg_assign_professional_communities_employees', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('namazeg_assign_id');

            $table->unsignedBigInteger('emplyee_id');
            $table->string('assignment_details');
            $table->string('class_teaching');
            
            $table->foreign('emplyee_id','delete_employee_id')->references('id')->on('school_employees')->onDelete('cascade');
            $table->foreign('namazeg_assign_id', 'delete_namazeg_assign')->references('id')->on('namazeg_assign_professional_communities')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('namazeg_assign_professional_communities_employees');
    }
};
