<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('namazeg_versions', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('namazeg_id');
            $table->string('serial_number')->nullable();
            $table->string('user_id')->nullable();
            $table->unsignedBigInteger('school_id');
            $table->foreign('namazeg_id')->references('id')->on('namazeg')->onDelete('cascade');
            $table->foreign('school_id')->references('id')->on('schools')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('namazeg_versions');
    }
};
