<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('general_assignment_employees', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('general_assignment_id');
            $table->unsignedBigInteger('employee_id');
            $table->timestamps();
            $table->softDeletes();
            
            $table->foreign('general_assignment_id')->references('id')->on('general_assignments')->onDelete('cascade');
            $table->foreign('employee_id')->references('id')->on('school_employees')->onDelete('cascade');

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('general_assignment_employees');
    }
};
