<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateShiftScheduleDaysTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('shift_schedule_days', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('shift_schedule_id');
            $table->unsignedBigInteger('semester_week_day_id');
            $table->timestamps();
            $table->softDeletes();
            $table->foreign('shift_schedule_id')->references('id')->on('shift_schedules')->onDelete('cascade');
            $table->foreign('semester_week_day_id')->references('id')->on('semester_week_days')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('shift_schedule_days');
    }
}
