<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('class_visit_needs', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('classVisit_id');
            $table->text('need')->nullable();
            $table->text('recommended')->nullable();
            $table->timestamps();

            $table->foreign('classVisit_id')->references('id')->on('class_room_visit_sessions')->onDelete('cascade');

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('class_visit_needs');
    }
};
