<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('meeting_recommendations', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('meeting_id')->nullable();
            $table->string('recommendation')->nullable();
            $table->string('executive_authority')->nullable();
            $table->string('execution_time')->nullable();
            $table->string('belonged_executive_authority')->nullable();
            $table->enum('recommendation_status', ['executed', 'not_executed'])->nullable();
            $table->string('reason_of_not_execution')->nullable();
            $table->timestamps();
            $table->softDeletes();

            // Foreign key constraint for parent meeting
            $table->foreign('meeting_id')->references('id')->on('meetings')->onDelete('cascade'); 
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('meeting_recommendations');
    }
};
