<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('meetings', function (Blueprint $table) {
            $table->id();
            $table->string('name')->nullable();
            $table->enum('model_type', ['committees', 'teams'])->nullable();
            $table->integer('model_id')->nullable();
            $table->enum('meeting_type', ['urgent', 'periodic'])->nullable();
            $table->string('date')->nullable();
            $table->enum('date_type', ['coptic', 'hijri'])->nullable();
            $table->string('start_time')->nullable();
            $table->string('end_time')->nullable();
            $table->string('place')->nullable();
            $table->integer('attendances_count')->nullable();
            $table->string('target_audience')->nullable();
            $table->enum('meeting_status', ['completed', 'not_completed', 'drafted'])->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('meetings');
    }
};
