<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('guides_and_regulations_files', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('guide_regulation_id')->nullable();
            $table->string('file_name')->nullable();
            $table->string('publish_date')->nullable();
            $table->enum('publish_date_type', ['coptic', 'hijri'])->nullable();
            $table->string('file_path')->nullable();
            $table->string('file_size')->nullable();
            $table->timestamps();
            $table->softDeletes();

            // Foreign key constraint for parent guide regulation
            $table->foreign('guide_regulation_id')->references('id')->on('guides_and_regulations')->onDelete('cascade'); 
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('guides_and_regulations_files');
    }
};
