<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('semester_vacations', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('semester_id')->nullable();
            $table->string('day')->nullable();
            $table->string('date')->nullable();
            $table->enum('date_type', ['coptic', 'hijri'])->nullable();
            $table->string('week_number')->nullable();
            $table->enum('status',[0,1])->default(1);
            $table->timestamps();
            $table->softDeletes();

            // Foreign key constraint for parent semester
            $table->foreign('semester_id')->references('id')->on('semesters')->onDelete('cascade'); 
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('semester_vacations');
    }
};
