<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('supervisors', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('supervision_schedule_id');
            $table->unsignedBigInteger('school_employee_id');
            $table->unsignedBigInteger('day_id');
            $table->unsignedBigInteger('floor_id');
            $table->foreign('supervision_schedule_id')->references('id')->on('supervision_schedules')->onDelete('cascade');
            $table->foreign('school_employee_id')->references('id')->on('school_employees')->onDelete('cascade');
            $table->timestamps();
            $table->softDeletes();

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('supervisors');
    }
};
