<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('violation_grades', function (Blueprint $table) {
            $table->id();
            $table->string('name', 150)->nullable();
            $table->unsignedBigInteger('violation_id');
            $table->foreign('violation_id')->references('id')->on('violations')->onDelete('cascade');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('violation_grades');
    }
};
