<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSchoolStudentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('school_students', function (Blueprint $table) {
            $table->id();
            $table->string('name', 150)->nullable()->collation('utf8mb4_general_ci');
            $table->string('ssn', 150)->nullable()->collation('utf8mb4_general_ci');
            $table->string('nationality', 150)->nullable()->collation('utf8mb4_general_ci');
            $table->string('phone', 50)->nullable()->collation('utf8mb4_general_ci');
            $table->unsignedBigInteger('school_id')->nullable();
            $table->foreign('school_id')->references('id')->on('schools')->onDelete('cascade');
            $table->unsignedBigInteger('class_id')->nullable();
            $table->foreign('class_id')->references('id')->on('school_classes')->onDelete('cascade');
            $table->string('current_school_year', 50)->collation('utf8mb4_general_ci');
            $table->timestamp('deleted_at')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('school_students');
    }
}

