<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSchoolClassesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('school_classes', function (Blueprint $table) {
            $table->id();  // UNSIGNED BIGINT, auto-incrementing primary key
            $table->unsignedBigInteger('school_id')->nullable();  // UNSIGNED BIGINT, nullable
            $table->integer('class_number')->nullable();  // VARCHAR(150), nullable
            $table->unsignedBigInteger('class_name_id')->nullable();  // BIGINT, nullable
            $table->string('school_year', 50)->nullable();  // VARCHAR(50), nullable
            $table->integer('n_students')->nullable();  // INT, nullable
            $table->enum('entsab', ['yes', 'no'])->default('no');  // ENUM('yes','no'), defaults to 'no'
            $table->timestamps();  // Adds 'created_at' and 'updated_at' columns
            $table->softDeletes();
            $table->foreign('class_name_id')->references('id')->on('class_names')->onDelete('cascade');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('school_classes');
    }
}
