<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('name', 255)->charset('utf8mb4')->collation('utf8mb4_unicode_ci');
            $table->string('email', 191)->charset('utf8mb4')->collation('utf8mb4_unicode_ci')->unique();
            $table->string('verification_code', 50)->nullable()->charset('utf8mb4')->collation('utf8mb4_unicode_ci');
            $table->string('password', 191)->nullable()->charset('utf8mb4')->collation('utf8mb4_unicode_ci');
            $table->text('remember_token')->nullable()->charset('utf8mb4')->collation('utf8mb4_unicode_ci');
            $table->string('image', 191)->nullable()->charset('utf8mb4')->collation('utf8mb4_unicode_ci');
            $table->string('phone', 191)->nullable()->charset('utf8mb4')->collation('utf8mb4_unicode_ci');
            $table->set('user_type', ['super_admin', 'admin', 'school_manager', 'teacher','adminstrative'])->nullable()->charset('utf8mb4')->collation('utf8mb4_unicode_ci');
            $table->enum('status', ['active', 'inactive', 'block'])->default('inactive')->charset('utf8mb4')->collation('utf8mb4_unicode_ci');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
    }
}

