<?php

namespace Database\Factories\AdminDashboard\School;

use App\Models\AdminDashboard\School\School;
use App\Models\AdminDashboard\School\SchoolGrade;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\AdminDashboard\School\SchoolClass>
 */
class SchoolClassFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $classNamesByGrade = [
            'الاعدادي' => ['الاول الاعدادي', 'الثاني الاعدادي', 'الثالث الاعدادي'],
            'الثانوي' => ['الاول الثانوي', 'الثاني الثانوي', 'الثالث الثانوي'],
        ];

        $grade = SchoolGrade::inRandomOrder()->first();
        $gradeName = $grade->name;

        // Check if the grade name contains 'الاعدادي'
        $isSecondary = str_contains($gradeName, 'الاعدادي');
        $classNames = $isSecondary ? $classNamesByGrade['الاعدادي'] : $classNamesByGrade['الثانوي'];
        return [
            'school_id' => School::inRandomOrder()->first()->id,
            'school_grade_id' => $grade->id,
            'class_name' => $this->faker->randomElement($classNames),
            'class_number' => $this->faker->numberBetween(1, 5),
            'class_category' => $this->faker->randomElement(['عام', 'خاص']),
            'school_year' => now()->year,
            'n_students' => $this->faker->numberBetween(20, 40),
        ];
    }
}
