<?php

namespace App\Traits;

use App\Models\Notification;
use App\Models\NotificationReceptor;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;

trait NotificationTrait
{
    // --------------  Website Notification
    public function CreateWebsiteNotification(string $title, string $body,string $school_id,array $user_ids,
        string $model = null,int $model_id = null,string $date = null, string $receptor= "specific_receptors")
    {
        $notification = Notification::create([
            'title'=> $title,
            'body'=> $body,
            'receptor'=> $receptor,
            'model'=> $model,
            'model_id'=> $model_id,
            'date'=> $date,
            'date_type'=> 'coptic',
        ]);
        foreach($user_ids as $user_id){
            NotificationReceptor::create([
                'school_id' => $school_id,
                'user_id' => $user_id,
                'user_type' => 'employee',
                'notification_id' => $notification->id,
            ]);
        }
    }

    
    // --------------  Mobile Notification
    public function CreateMobileNotification(string $title, string $body,string $school_id,array $user_ids,
        string $model = null,int $model_id = null,string $date = null, string $receptor= "specific_receptors")
    {
        $notification = Notification::create([
            'title'=> $title,
            'body'=> $body,
            'receptor'=> $receptor,
            'model'=> $model,
            'model_id'=> $model_id,
            'date'=> $date,
            'date_type'=> 'coptic',
            'notification_type'=> 'app',
        ]);
        foreach($user_ids as $user_id){
            NotificationReceptor::create([
                'school_id' => $school_id,
                'user_id' => $user_id,
                'user_type' => 'employee',
                'notification_id' => $notification->id,
            ]);
        }
    }

}
