<?php

namespace App\Traits;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;

trait LogsActivity
{
    public function AdminlogActivity(string $model, string $action, string $event_link = null)
    {
        $activity = activity()
            ->causedBy(Auth::user())
            ->event($action);
        if ($event_link !== null) {
            $activity->withProperties(['event_link' => $event_link]); // Event Link
        }
        $activity->log($model);
    }
    public function ManagerlogActivity(string $model, string $action, string $school_id, string $event_link = null)
    {
        $properties = ['school_id' => $school_id];

        // Add the event link if provided
        if ($event_link !== null) {
            $properties['event_link'] = $event_link;
        }

        activity()
            ->causedBy(Auth::user()) // user_id
            ->event($action) // Sets the event name
            ->withProperties($properties) // School ID
            ->log($model);
    }
}
