<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;

class ViolationTitle extends Model
{ 
    use HasFactory,SoftDeletes;

    protected $table='violation_titles';
    protected $guarded=[];


    public function types(){
        return $this->hasMany(ViolationType::class);
    }
    public function punishments(){
        return $this->hasMany(ViolationPunishment::class);
    }
    public function violation_name(){
        return $this->belongsTo(ViolationName::class,'name');
    }
}
