<?php

namespace App\Models\ManagerDashboard;

use App\Models\AdminDashboard\School\Period ;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\AdminDashboard\School\Subject;
use App\Models\AdminDashboard\School\Teacher;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

use App\Models\Day;

class TeacherScheduleData extends Model
{
    use HasFactory;

    protected $table = 'teacher_schedul_data';
    protected $guarded = [];

    public function day_name()
    {
        return $this->belongsTo(Day::class, 'day_id');
    }
    public function period()
    {
        return $this->belongsTo(Period::class);
    }
    public function employee()
    {
        return $this->belongsTo(SchoolEmployee::class, 'teacher_schedule_id');
    }
    public function subject()
    {
        return $this->belongsTo(Subject::class, 'subject_id');
    }

}
