<?php

namespace App\Models\ManagerDashboard\Messages;

use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\AdminDashboard\School\Student;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;


class MessageReciver extends Model
{
    use HasFactory;

    protected $table = 'messages_recieves';
    protected $guarded = [];


    public function users()
    {
        if ($this->user_type == "employee") {
            return $this->belongsTo(SchoolEmployee::class, 'user_id');
        } elseif ($this->user_type == "student") {
            return $this->belongsTo(Student::class, 'user_id');
        }
    }
    public function employee()
    {
        return $this->belongsTo(SchoolEmployee::class, 'user_id');
    }
    public function student()
    {
        return $this->belongsTo(Student::class, 'user_id');
    }

    public function getUserAttribute()
    {
        if ($this->user_type === "employee") {
            return SchoolEmployee::find($this->user_id);
        } elseif ($this->user_type === "student") {
            return Student::find($this->user_id);
        }

        return null;
    }


    public function message()
    {
        return $this->belongsTo(Message::class, 'message_id');
    }
}
