<?php

namespace App\Models\ManagerDashboard\ClassRoomVisits;

use App\Models\AdminDashboard\School\Period;
use App\Models\AdminDashboard\School\SchoolClass;
use App\Models\AdminDashboard\School\SchoolEmployee;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ClassRoomVisitSession extends Model
{
    use HasFactory; use SoftDeletes;

    protected $guarded = [];

    public function teacher()
    {
        return $this->belongsTo(SchoolEmployee::class,'school_teacher_id');    
    }
    public function class()
    {
        return $this->belongsTo(SchoolClass::class,'school_class_id')->with('className');    
    }

    public function className()
    {
        return  SchoolClass::where('class_name_id',$this->class_id)->first();
    }
    public function visitOfficer()
    {
        return $this->belongsTo(SchoolEmployee::class,'visit_officer_id');    
    }
    public function period()
    {
        return $this->belongsTo(Period::class,'visit_period_id');    
    }
    
}
