<?php

namespace App\Models\ManagerDashboard\Circulars;

use App\Models\AdminDashboard\School\School;
use App\Models\AdminDashboard\School\Student;
use App\Traits\CascadeSoftDeletes;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Casts\Attribute;


class StudentGeneralCircular extends Model
{
    use SoftDeletes,CascadeSoftDeletes;
    protected $table='student_general_circulars';
    protected $guarded = [];
    protected $cascadeDeletes = ['circularStudents'];

    protected function createdAt(): Attribute
    {
        return Attribute::make(
            get: fn (string $value) => \Carbon\Carbon::parse($value)->format('m/d/Y'),
        );
    }


    public function circularStudents()
    {
        return $this->hasMany(StudentGeneralCircularStudent::class, 'student_general_circular_id');
    }

    public function school()
    {
        return $this->belongsTo(School::class, 'school_id');
    }

    public function students()
    {
        return $this->hasManyThrough(
            Student::class,
            StudentGeneralCircularStudent::class,
            'student_general_circular_id', // Foreign key on CirclersTeachers table...
            'id', // Foreign key on Teachers table...
            'id', // Local key on internal circulars table...
            'student_id' // Local key on internal Circular Teachers table...
        );
    }
}
