<?php

namespace App\Models\AdminDashboard\School;

use App\Models\ManagerDashboard\NotificationReciver;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;


class Student extends Model
{
    use SoftDeletes, HasFactory;

    protected $table = 'school_students';
    protected $guarded = [];

    public function my_notification()
    {
        return $this->hasOne(NotificationReciver::class, 'user_id', 'id')
            ->orderBy('updated_at', 'Desc')
            ->with('message');
    }

    public function schoolClass()
    {
        return $this->belongsTo(SchoolClass::class, 'class_id');
    }
}
