<?php

namespace App\Models\AdminDashboard\School;

use App\Models\Day;
use App\Models\Week;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;


class  SemesterWeekDay extends Model
{
    use SoftDeletes;

    protected $table= 'semester_week_days';
    protected $guarded= [];


    public function semester(){
        return $this->belongsTo(SchoolSemester::class,'semester_id');
    }

    public function week(){
        return $this->belongsTo(Week::class,'week_id');
    }

    public function day(){
        return $this->belongsTo(Day::class,'day_id');
    }
}
