<?php

namespace App\Models\AdminDashboard\School;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use App\Models\AdminDashboard\School\SchoolGrade;
use App\Models\AdminDashboard\EducationalDepartment\EducationalDepartment;
use App\Models\AdminDashboard\EducationalOffice\EducationalOffice;
use App\Models\AdminDashboard\AreaAndCities\Area;
use App\Models\AdminDashboard\AreaAndCities\City;

class School extends Model
{
    use HasFactory; use SoftDeletes;

    protected $table= 'schools';
    protected $guarded= [];

    public function schoolGrade(){
        return $this->belongsTo(SchoolGrade::class);
    }

    public function educationDepartment(){
        return $this->belongsTo(EducationalDepartment::class);
    }

    public function educationalOffice(){
        return $this->belongsTo(EducationalOffice::class);
    }

    public function area(){
        return $this->belongsTo(Area::class);
    }

    public function city(){
        return $this->belongsTo(City::class);
    }
    
}
