<?php
namespace App\Imports;

use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use App\Models\AdminDashboard\School\Student;
use App\Models\AdminDashboard\School\SchoolClass;
use App\Models\AdminDashboard\School\ClassName;

use App\Models\AdminDashboard\School\School;
use App\Helpers\Helper;
use Illuminate\Support\Facades\Log;

class StudentsBaseImport implements ToCollection,WithHeadingRow
{
    protected $file;
    protected $skipRows;
    protected $schoolId;
    protected $sheetName;
    
    public function __construct($file,array $skipRows = [],$schoolId,$sheetName)
    {
        $this->file = $file;
        $this->skipRows = $skipRows;
        $this->schoolId = $schoolId;
        $this->sheetName = $sheetName;
    }  

    public function collection(Collection $rows){   
        
        $filteredRows = $rows->filter(function ($row, $index) {
            // Skip row if it is in the skip list (index starts from 1 including heading row)
            return !in_array($index , $this->skipRows);
        });
 
        $school=School::find($this->schoolId);

        /** check data started from row 21 in sheet 1 and all sheets started from row 20 */
        $school_year =Helper::getSchoolYear();
        $class_name=($this->sheetName == 'Sheet1')?$filteredRows[4][4]:$filteredRows[3][4];
        $class_category= ($this->sheetName == 'Sheet1')?$filteredRows[8][4]:$filteredRows[7][4];
        $class_number= ($this->sheetName == 'Sheet1')?$filteredRows[12][4]:$filteredRows[11][4];

        /** add new class name */
        $className= ClassName::where('school_grade_id',$school->school_grade_id)->where('name',$class_name)->where('category',$class_category)->first();
        if(!$className){

            $className = new ClassName();
            $className->school_grade_id = $school->school_grade_id;
            $className->name = $class_name;
            $className->category = $class_category;
            $className->save();
        }
        
      
        /** check school class created before or not */
        $schoolClass = SchoolClass::where('school_id',$school->id)->where('class_name_id',$className->id)->where('class_number',$class_number)->first();
        if(!$schoolClass){
            $schoolClass = new SchoolClass();
            $schoolClass->school_id = $school->id;
            $schoolClass->school_year = $school_year;
            $schoolClass->class_name_id = $className->id;
            $schoolClass->class_number = $class_number;
            $schoolClass->n_students = 0;
            $schoolClass->save();
        }

        /** unset particular rows */
        unset($filteredRows[1]);
        unset($filteredRows[3]);
        unset($filteredRows[4]);
        unset($filteredRows[6]);
        unset($filteredRows[7]);
        unset($filteredRows[8]);
        unset($filteredRows[11]);
        unset($filteredRows[12]);

        /** add class students */
        foreach ($filteredRows as $row) {
            if(is_numeric($row[20])){
                Student::create([
                    'name' => $row[28],
                    'ssn' => $row[20],
                    'nationality' => $row[23],
                    'phone' => $row[2],
                    'class_id' => $schoolClass->id,
                    'school_id' => $this->schoolId,
                    'current_school_year'=>$school_year
                ]);
            }

            /** increment total class students */
            $schoolClass->n_students+= 1;
            $schoolClass->save();
        }
    }
}

