<?php

namespace App\Http\Resources\Video;

use App\Http\Resources\AdminDashboard\Category\CategoryResource;
use App\Models\Video;
use Illuminate\Http\Resources\Json\JsonResource;
use Carbon\Carbon;

class VideoResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id'=>$this->id,
            'name'=>$this->name,
            'category_id'=>$this->category_id,
            'category' => new CategoryResource($this->category),
            'video_link'=>$this->video_link,
            'created_at' => Carbon::parse($this->created_at)->format('g:i A')
        ];
    }
}
