<?php

namespace App\Http\Resources\School;

use App\Helpers\Helper;
use Illuminate\Http\Resources\Json\JsonResource;
class SchoolSemesterResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $lang = $request->header('lang');
        return [
            'id'=>$this->id,
            'name' =>$this->name,
            'start_date' =>$this->start_date,
            'end_date' =>$this->end_date,
            'start_date_type' =>(isset($this->start_date_type)) ? trans('api.'.$this->start_date_type) : '',
            'end_date_type' =>(isset($this->end_date_type)) ? trans('api.'.$this->end_date_type) : '',
            'start_date_options'=> Helper::getDateOptions($this->start_date, $this->start_date_type),
            'end_date_options'=> Helper::getDateOptions($this->end_date, $this->end_date_type),
            'period' => ($lang == 'ar') ? $this->period : $this->period,
            'status'=>($this->status == 1)?trans('api.active'):trans('api.inactive'),
        ];
    }
}
