<?php

namespace App\Http\Resources\School;

use App\Models\AdminDashboard\School\SchoolFacilitie;
use App\Models\AdminDashboard\School\SchoolReference;
use Illuminate\Http\Resources\Json\JsonResource;
use App\Http\Resources\School\SchoolReferenceResource;
use App\Http\Resources\School\SchoolFacilitieResource;

class SchoolResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $lang = $request->header('lang');
        $schoolFacilities= new SchoolFacilitieResource(SchoolFacilitie::where('school_id',$this->id)->first());
        $schoolReferences= new SchoolReferenceResource(SchoolReference::where('school_id',$this->id)->first());
        return [
            'id'=>$this->id,
            'shift'=>$this->shift,
            'gender'=>$this->gender,
            'childhood'=>$this->childhood?$this->childhood:'no',
            'school_grade'=>$this->schoolGrade?->name,
            'name'=>$this->name,
            'ministry_number'=>$this->ministry_number,
            'education_type'=>$this->education_type,
            'education_department'=>$this->educationDepartment?->name,
            'educational_office'=>$this->educationalOffice?->name,
            'founding_date'=>$this->founding_date,
            'founding_date_type'=>$this->founding_date_type,
            'address'=>$this->address,
            'area_id'=>$this->area?->name,
            'city_id'=>$this->city?->name,
            'current_school_year'=>$this->current_school_year,
            'registration_complete'=>($this->registration_complete)?$this->registration_complete:'no',
            'schoolFacilities'=>$schoolFacilities,
            'schoolReferences'=>$schoolReferences,
        ];
    }
}
