<?php

namespace App\Http\Resources\ManagerDashboard\TeacherSchedule;
use Illuminate\Http\Resources\Json\JsonResource;

class TeacherScheduleDataResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id'=>$this->id,
            'school_employee_id'=>$this->school_employee_id,
            'employee'=>$this->employee?->name,

            'subject_id'=>$this->subject_id,
            'subject'=>$this->subject->name,

            'period_id'=>$this->period_id,
            'period'=>$this->period->name,
            
            'day_id'=>$this->day_id,
            'day'=>$this->day_name->name,
        ];
    }
}
