<?php

namespace App\Http\Resources\ManagerDashboard\Tables\ClassRoomVisits;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\ResourceCollection;

class ClassroomVisitCollection extends ResourceCollection
{
    /**
     * Transform the resource collection into an array.
     *
     * @return array<int|string, mixed>
     */
    public function toArray(Request $request): array
    {
        $grouped = $this->collection->groupBy('semester_id')->map(function ($semesterVisits, $semesterId) {
            $semester = $semesterVisits->first()->semester; // Assuming the relationship is named 'semester'
            return [
                'semester_id' => $semesterId,
                'semester_name' => $semester->name,
                'visits' => ClassroomVisitResource::collection($semesterVisits)
            ];
        });

        return [
            'semesters' => $grouped->values(),
        ];
    }
}
