<?php

namespace App\Http\Resources\ManagerDashboard\Proceed;

use App\Helpers\Helper;
use App\Http\Resources\School\SchoolEmployeeResource;
use Illuminate\Http\Resources\Json\JsonResource;
use Carbon\Carbon;

class ProceedResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id'=>$this->id,
            'title'=>$this->title,
            'text'=>$this->text,
            'date_type' => __('api.' . $this->date_type),
            'date' => Carbon::createFromFormat('d/m/Y', $this->date)->format('d/m/Y'),
            'date_options' => Helper::getDateOptions($this->date, $this->type),
            'employees' => $this?->proceedUsers->map(function ($user) {
                return new SchoolEmployeeResource($user->employee);
            }),
        
        ];
    }
}
