<?php

namespace App\Http\Resources\ManagerDashboard\Notification;

use App\Helpers\Helper;
use App\Models\Notification;
use Illuminate\Http\Resources\Json\JsonResource;
use Carbon\Carbon;

class NotificationResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        Carbon::setlocale('ar');
        if($this->notification->date){
            $date =Carbon::createFromFormat('d/m/Y',$this->notification->date)->diffForHumans();
        }else{
            $date =$this->notification->updated_at->diffForHumans();
        }
        return [
            'id' => $this->id,
            'title' => $this->notification->title,
            'body' => $this->notification->body,
            'date' => $date,
            'model' => $this->notification->model,
            'model_id' => $this->notification->model_id,
            'seen' => $this->seen,
            'open' => $this->open,
        ];
    }
}
