<?php

namespace App\Http\Resources\ManagerDashboard\ClassRoomVisit;

use App\Models\ManagerDashboard\ClassRoomVisits\ClassVisitCard;
use App\Models\ManagerDashboard\ClassRoomVisits\VisitMethod;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ClassvisitCardResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
      
        $classVisitCard = ClassVisitCard::where('classVisit_id',$this->classRoomVisit->id)->firstOrFail();
        
        $visitMethodIds = $classVisitCard->visit_method_ids;
       
        $visitMethods = VisitMethod::whereIn('id', $visitMethodIds)->get(['id', 'title']);
       
        return [
            'teacher' => $this->ClassRoomVisit->teacher->name,
            'teacher_nationality' => $this->teacher_nationality,
            'teacher_qualification' => $this->teacher_qualification,
            'teacher_specialization' => $this->ClassRoomVisit->teacher->specialization?->title,
            'teaching_field' => $this->teaching_field,
            'direct_school_date' => $this->direct_school_date,
            'Date_of_visit' => $this->ClassRoomVisit->date,
            'teacher_new_to_subject' => $this->teacher_new_to_subject,
            'visit_type' => $this->visit_type,
            'visit_methods' => $visitMethods,
            'additional_methods' => $this->additional_methods,  
        ];
    }
}
