<?php

namespace App\Http\Resources\ManagerDashboard\ClassRoomVisit;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ClassVisitRateResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'class' => $this->ClassRoomVisit->class->className->name,
            'period' => $this->ClassRoomVisit->period->name,
            'subject' => $this->subject->name,
            'lesson_title_rate' => $this->lesson_title_rate,
            'number_of_class_students' => $this->number_of_class_students,
            'number_of_attendees' => $this->number_of_attendees,
            'number_of_absences' => $this->number_of_absences,
            'visit_number' => $this->visit_number,
            'purpose_of_visit' => $this->purpose_of_visit,
            'class_visit_meeting_teacher' => $this->class_visit_meeting_teacher,
            'know_participation_subject_activities' => $this->know_participation_subject_activities,
            'review_written_preparation_lesson' => $this->review_written_preparation_lesson,
            'discussion_school_manager' => $this->discussion_school_manager,
            'view_assignments_applications' => $this->view_assignments_applications,
            'visit_student_mentor' => $this->visit_student_mentor,
            'view_calendar_tests' => $this->view_calendar_tests,
            'responsibility_rate' => $this->responsibility_rate,
            'responsibility_desc' => $this->responsibility_desc,
            'communication_collaboration_rate' => $this->communication_collaboration_rate,
            'communication_collaboration_desc' => $this->communication_collaboration_desc,
            'adherence_dialogue_etiquette_verbally_and_writing_rate' => $this->adherence_dialogue_etiquette_verbally_and_writing_rate,
            'adherence_dialogue_etiquette_verbally_and_writing_desc' => $this->adherence_dialogue_etiquette_verbally_and_writing_desc,
            'development_rate' => $this->development_rate,
            'development_desc' => $this->development_desc,
            'exchanging_experiences_rate' => $this->exchanging_experiences_rate,
            'exchanging_experiences_desc' => $this->exchanging_experiences_desc,
            'providing_knowledge_production_rate' => $this->providing_knowledge_production_rate,
            'providing_knowledge_production_desc' => $this->providing_knowledge_production_desc,
            'design_course_plan_rate' => $this->design_course_plan_rate,
            'design_course_plan_desc' => $this->design_course_plan_desc,
            'lesson_preparing_rate' => $this->lesson_preparing_rate,
            'lesson_preparing_desc' => $this->lesson_preparing_desc,
            'preparation_learning_objectives_rate' => $this->preparation_learning_objectives_rate,
            'preparation_learning_objectives_desc' => $this->preparation_learning_objectives_desc,
            'implementing_lesson_achieves_rate' => $this->implementing_lesson_achieves_rate,
            'implementing_lesson_achieves_desc' => $this->implementing_lesson_achieves_desc,
            'employing_educational_techniques_rate' => $this->employing_educational_techniques_rate,
            'employing_educational_techniques_desc' => $this->employing_educational_techniques_desc,
            'using_distance_education_platforms_rate' => $this->using_distance_education_platforms_rate,
            'using_distance_education_platforms_desc' => $this->using_distance_education_platforms_desc,
            'providing_scientific_material_rate' => $this->providing_scientific_material_rate,
            'providing_scientific_material_desc' => $this->providing_scientific_material_desc,
            'apply_educational_strategies_rate' => $this->apply_educational_strategies_rate,
            'apply_educational_strategies_desc' => $this->apply_educational_strategies_desc,
            'linking_lesson_real_life_rate' => $this->linking_lesson_real_life_rate,
            'linking_lesson_real_life_desc' => $this->linking_lesson_real_life_desc,
            'asking_appropriate_class_questions_rate' => $this->asking_appropriate_class_questions_rate,
            'asking_appropriate_class_questions_desc' => $this->asking_appropriate_class_questions_desc,
            'involving_students_lesson_activities_rate' => $this->involving_students_lesson_activities_rate,
            'involving_students_lesson_activities_desc' => $this->involving_students_lesson_activities_desc,
            'evaluating_learning_diagnose_student_rate' => $this->evaluating_learning_diagnose_student_rate,
            'evaluating_learning_diagnose_student_desc' => $this->evaluating_learning_diagnose_student_desc,
            'building_integrated_plan_rate' => $this->building_integrated_plan_rate,
            'building_integrated_plan_desc' => $this->building_integrated_plan_desc,
            'employing_classroom_applications_rate' => $this->employing_classroom_applications_rate,
            'employing_classroom_applications_desc' => $this->employing_classroom_applications_desc,
            'creating_educational_environment_rate' => $this->creating_educational_environment_rate,
            'creating_educational_environment_desc' => $this->creating_educational_environment_desc,
            'department_student_contributions_inquiries_rate' => $this->department_student_contributions_inquiries_rate,
            'department_student_contributions_inquiries_desc' => $this->department_student_contributions_inquiries_desc,
            'managing_learning_time_rate' => $this->managing_learning_time_rate,
            'managing_learning_time_desc' => $this->managing_learning_time_desc,
            'student_interaction_level_rate' => $this->student_interaction_level_rate,
            'student_interaction_level_desc' => $this->student_interaction_level_desc,
            'student_achievement_level_rate' => $this->student_achievement_level_rate,
            'student_achievement_level_desc' => $this->student_achievement_level_desc,
        ];

    }
}
