<?php

namespace App\Http\Resources\ManagerDashboard\ClassRoomVisit;

use Alkoumi\LaravelHijriDate\Hijri;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Carbon\Carbon;
use IntlDateFormatter;
use App\Helpers\Helper;


class ClassRoomvisitResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        // Set locale to Arabic
        Carbon::setLocale('ar');

        // Parse the date from the format `d/m/Y`
        $gregorianDate = Carbon::createFromFormat('d/m/Y', $this->date);

        // Initialize date variable
        $formattedDate = '';

        if ($this->date_type === 'coptic') {
            $date = Helper::getDateOptions($this->date,$this->date_type)['coptic'];
            $gregorianDate = Carbon::createFromFormat('d/m/Y', $date);
            $date = $gregorianDate->translatedFormat('l d F Y');
        }else{
             $date = Helper::getDateOptions($this->date,$this->date_type)['hijri'];
             $date = Helper::getCoptic($this->date);

             $gregorianDate = Carbon::createFromFormat('d/m/Y', $date);
           
            $date =  Hijri::Date('l ، j F ، Y', $gregorianDate); 
        }


        
        return [
            'id' => $this->id,
            'teacher' => $this->teacher?->name,
            'class' => $this->class->className->name,
            'classNumber' => $this->class->class_number,
            'date' => $date,
            'dat_options'=> Helper::getDateOptions($this->date,$this->date_type),
            'date_type' => $this->date_type,
            'visitOfficer' => $this->visitOfficer?->name,
            'visitPeriod' => $this->period->name,
            'visitStatus' => $this->visit_status,
        ];
    }
}
