<?php

namespace App\Http\Resources\ManagerDashboard\Assignments;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class GeneralAssignmentResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
{
    return [
        'assignment_id' => $this->id,
        // 'school_id' => $this->school_id,
        'date_type' => $this->date_type,
        'date' =>  $this->date,
        // 'assignment_duration' => $this->duration?->year,
        // 'details' => $this->details,
        'employees' => $this->generalAssignmentEmployees->map(function ($generalAssignmentEmployee) {
          
            return [
                'id' => $generalAssignmentEmployee->employee?->id,
                'name' => $generalAssignmentEmployee->employee?->name,
                'ssn' => $generalAssignmentEmployee->employee?->ssn,
                'specialization' => $generalAssignmentEmployee->employee?->specialization?->title,
            ];
        }),
    ];

}
}
