<?php

namespace App\Http\Resources\ManagerDashboard\Assignments;

use App\Http\Resources\ManagerDashboard\TeamAndCommitteeMeetings\CommiteeMemberResource;
use App\Http\Resources\ManagerDashboard\TeamAndCommitteeMeetings\MeetingResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class CommitteeAssignmentResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
       
        return [
            'committee_id' => $this->id,
            'name' => $this->name,
            'form_number'=> $this->assignment_form_number,
            'assignment_id' => $this->assignment ? $this->assignment->id : null,
            'assignment_date_type' => $this->assignment ? $this->assignment->date_type : null,
            'assignment_date' => $this->assignment ? $this->assignment->date : null,
            'members' => $this->members?->map(function ($member){
              
                return   new CommiteeMemberResource($member);
                
            }),
            'meetings' => $this->meetings?->map(function ($metting){
                return   new MeetingResource($metting);
                
            }),
            
            


        ];
    }
}
