<?php

namespace App\Http\Resources\ManagerDashboard\Assignments;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class AssignmentCurrentWorkResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->job_title ?? $this->name, // Handle both job title and committee/team name
            'form_number' => $this->assignment_form_number ?? null,
            'employees' => $this->assignments ? $this->assignments->flatMap(function ($assignment) {
                return $assignment->assignmentEmployees->map(function ($assignmentEmployee) use ($assignment) {
                    return [
                        'assignment_id' => $assignment->id,
                        'assignment_date' => $assignment->date ?? 'No date',
                        'employee_id' => $assignmentEmployee->employee?->id, 
                        'name' => $assignmentEmployee->employee->name ?? 'No name', 
                        'civil_record_number' => $assignmentEmployee->employee->ssn ?? 'No SSN', 
                        'specialization' => $assignmentEmployee->employee->specialization->title ?? 'No specialization', 
                       
                    ];
                });
            }) : [], // Return an empty array if assignments are null
        ];
    }
}
