<?php

namespace App\Http\Requests\School;

use App\Models\SchoolSemester;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Request;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\ValidationException;

class StudentRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(Request $request)
    {
        return [
            'name' => 'required|string|max:100',
            'ssn' => 'required',
            'nationality' => 'required|string|max:100',
            'school_id' => 'required|exists:schools,id',
            'class_id' => 'required|exists:school_classes,id',
        ];
    }

}
