<?php

namespace App\Http\Requests\School;

use Illuminate\Http\Request;
use Illuminate\Foundation\Http\FormRequest;

class SchoolEmployeeRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(Request $request)
    { 
        if ($this->isMethod('post')) {
            return [
                'name' => 'required|string|max:100',
                'ssn' => 'required|unique:school_employees',
                'email' => 'required|string|email|max:255|unique:school_employees',
                'phone' => 'required|string|unique:school_employees',
                'current_work_id'=>'exists:current_works,id',
                'specialization_id'=>'required|exists:specializations,id',
                'school_id'=>'required|exists:schools,id',
            ];
        }


        if ($this->isMethod('put') || $this->isMethod('patch')) {
            $id = $this->route('id');
            
            return [
                'name' => 'required|string|max:100',
                'ssn' => 'required|unique:school_employees,ssn,'.$id,
                'email' => 'required|string|email|max:255|unique:school_employees,email,'.$id,
                'phone' => 'required|string|unique:school_employees,phone,'.$id,
                'current_work_id'=>'exists:current_works,id',
                'specialization_id'=>'required|exists:specializations,id',
                'school_id'=>'required|exists:schools,id',
            ];
        }

        return [];
    }

}
