<?php

namespace App\Http\Requests\Notification;

use Illuminate\Http\Request;
use Illuminate\Foundation\Http\FormRequest;

class NotificationStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(Request $request)
    {
        $rules = [
            'title' => 'required|string',
            'body' => 'required|string',
            'date' => [
                'string',
                'regex:/^(0[1-9]|[12][0-9]|3[01])\/(0[1-9]|1[0-2])\/\d{4}$/'
            ],
            'receptor' => 'required|string|in:all_cities,specific_cities,specific_receptors',
            'scheduled' => 'required|string|in:1,0',
        ];

        if ($request->receptor !== 'all_cities') {
            $rules['selected_targets'] = 'required|array';
        }
        if ($request->date_type) {
            $rules['date_type'] = 'string|in:coptic,hijri';
        }

        return $rules;
    }
}
