<?php

namespace App\Http\Requests\ManagerDashboard\Messages;

use Illuminate\Http\Request;
use Illuminate\Foundation\Http\FormRequest;

class MessageStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(Request $request)
    {
        $rules = [
            'message' => 'required|string',
            'user_type' => 'required|string|in:employee,student',
            'school_id' => 'required|string|exists:schools,id',
        ];
        if($request->user_type== 'student'){
            $rules['reciver_ids']= 'required|array|exists:school_students,id';
        }else{
            $rules['reciver_ids']= 'required|array|exists:school_employees,id';
        }
        return $rules;
    }
}
