<?php

namespace App\Http\Requests\ManagerDashboard\ClassRoomVisit;

use Illuminate\Foundation\Http\FormRequest;

class StoreClassRoomVisitRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
           'school_id' => ['required','integer','exists:schools,id'],
           'semester_id' => ['required','integer','exists:semesters,id'],
           'school_teacher_id' => ['required','integer','exists:school_employees,id'],
           'school_class_id' => ['required','integer','exists:school_classes,id'],
           'date' => ['required', ],
           'date_type' => ['in:coptic,hijri'],
           'visit_officer_id' => ['required','exists:school_employees,id'],
           'visit_period_id' => ['required','exists:periods,id'],
           'visit_status' => ['in:complete,incomplete'],
        ];
    }
}
