<?php

namespace App\Http\Requests\AdminDashboard\AreasAndCities;

use Illuminate\Foundation\Http\FormRequest;

class StoreAreaRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'name' => ['required','string','min:3','max:255'],
            'status' =>[ 'in:true, false, 1, 0,'],
            'city' => 'required|array|min:1', 
            'city.*' => 'string', 
         ];
    }

    public function messages()
    {
        return [
            'name.required' => 'حقل الاسم مطلوب.',
            'name.string' => 'يجب أن يكون الاسم نصًا.',
            'name.min' => 'يجب ألا يقل الاسم 3 حرفًا.',
            'name.max' => 'يجب ألا يتجاوز الاسم 255 حرفًا.',
            'city.required' => 'يجب تحديد مدينه.',
            'status.in' => 'يجيب ادخال قيمة 0 او 1',
        ];
    }
    
}
